/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

final String projectName = props['automation/projectName']
final String url = props['automation/url']
final String username = props['automation/username']
final String password = props['automation/password']
final String passScript = props['automation/passScript']

final String defectName = props['defectName']
final String description = props['description']
final String type = props['type']

final String severity = props['severity']
final String priority = props['priority']
final String state = props['state']
final String submitter = props['submitter']
final String build = props['build']

CreateDefect cd = new CreateDefect()
cd.projectName = projectName
cd.url = url
cd.username = username
cd.password = password
cd.passScript = passScript

cd.defectName = defectName
cd.description = description
cd.type = type

cd.severity = severity
cd.priority = priority
cd.state = state
cd.submitter = submitter
cd.build = build

cd.execute(props, apTool)