/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.lazy.LazyFinalReference;
import com.urbancode.commons.util.lazy.SafeLazyFinalReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;

@BridgeMethodsAdded
public class UniqueIDGenerator {
    public static final int ID_LENGTH = 20;
    private static final String ID_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final SecureRandom random = new SecureRandom();
    private static final LazyFinalReference<Base64> encoder = new SafeLazyFinalReference<Base64>(){

        @Override
        protected Base64 initialValue() {
            return new Base64();
        }
    };
    private static final LazyFinalReference<MessageDigest> messageDigest = new SafeLazyFinalReference<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String getNextID() {
        return UniqueIDGenerator.getNextID(20);
    }

    public static synchronized String getNextID(int length) {
        char[] buffer = new char[length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = ID_CHARS.charAt(random.nextInt(ID_CHARS.length()));
        }
        return new String(buffer);
    }

    public static String getNextSecureID(String key) throws NoSuchAlgorithmException {
        return UniqueIDGenerator.getNextSecureID(20, key);
    }

    public static String getNextSecureID(int idLength, String key) throws NoSuchAlgorithmException {
        if (messageDigest == null) {
            throw new NoSuchAlgorithmException("MD5 algorithm not found");
        }
        byte[] digest = messageDigest.get().digest(UniqueIDGenerator.getNextID(idLength).getBytes());
        digest = messageDigest.get().digest((new String(digest) + key).getBytes());
        return new String(digest);
    }

    public static String getNextPrintableSecureID(String key) throws NoSuchAlgorithmException {
        String ID = UniqueIDGenerator.getNextSecureID(key);
        String encoded = new String(encoder.get().encode(ID.getBytes()));
        encoded = encoded.substring(0, encoded.length() - 2);
        return encoded;
    }
}

