import com.urbancode.air.*
import java.io.File;

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def apTool                = new AirPluginTool(this.args[0], this.args[1])

final def props                 = apTool.getStepProperties()

final File   workDir            = new File('.', props['workDirOffset'] ?: '.').canonicalFile
final CommandHelper cmdHelper   = new CommandHelper(workDir);

final String rakeFileName       = props['rakeFile'] ?: 'rakefile'
final String targets            = props['targets'] ?: 'default'
final String rakeLib            = props['rakeLib']
final String rakeHome           = props['rakeHome']
final String rakeProperties     = props['rakeProperties']
final String scriptContent      = props['scriptContent']

if (workDir.isFile()) {
    throw new IllegalArgumentException("Working Directory ${workDir} is a file.")
}

if (!rakeHome || "" == rakeHome.trim()) {
    throw new IllegalArgumentException("RAKE_HOME not specified.");
}

workDir.mkdirs();

final File rakeFile = new File(workDir, rakeFileName)
boolean deleteOnExit = false
if (scriptContent) {
    rakeFile.text = scriptContent
    deleteOnExit = true
}

try {
    def rakeExe = new File(rakeHome, "bin/rake")
    def commandLine = [rakeExe, '-f', rakeFile.absolutePath]
    
    if (rakeProperties) {
        rakeProperties.readLines().each() { prop ->
            commandLine << prop
        }
    }
    
    if (targets) {
        targets.split("\\s").each { target ->
            commandLine << target
        }
    }
    
    if (rakeLib) {
        commandLine << "-R" << rakeLib
    }
    
    cmdHelper.runCommand("Executing Rake File", commandLine)
}
finally {
    if (deleteOnExit) {
        rakeFile.delete()
    }
}