/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String server             = props['automation/rallyUrl']
final String url                = server + "/slm/webservice/v2.0/"
final String user               = props['automation/rallyUser']
final String password           = props['automation/rallyPass'] ?: props['automation/passScript']
final String proxyHost          = props['automation/proxyHost']
final String proxyPort          = props['automation/proxyPort']
final String proxyPass          = props['automation/proxyPass']
final String proxyUser          = props['automation/proxyUser']
final String workspace          = props['automation/workspace']

final String defectPattern  = props['defectPattern']
final String taskPattern    = props['taskPattern']
final String usPattern      = props['usPattern']
final String comment        = props['comment']

if (!defectPattern && !taskPattern && !usPattern) {
    println "No patterns supplied for defects, tasks, or user stories. No comments will be added."
    System.exit(1)
}

println "Server:\t" + server
println "Url:\t" + url
println "Defect Pattern:\t" + defectPattern
println "Task Pattern:\t" + taskPattern
println "User Story Pattern:\t" + usPattern

//-------------------------------------------------------------------------
// Execute
//=========================================================================

AddComment ac = new AddComment()
ac.url = url
ac.user = user
ac.password = password
ac.proxyHost = proxyHost
ac.proxyPort = proxyPort
ac.proxyPass = proxyPass
ac.proxyUser = proxyUser
ac.workspace = workspace

ac.defectPattern = defectPattern
ac.taskPattern = taskPattern
ac.usPattern = usPattern
ac.comment = comment

ac.execute()
