/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String server         = props['automation/rallyUrl']
final String url            = server + "/slm/webservice/v2.0/"
final String user           = props['automation/rallyUser']
final String password       = props['automation/rallyPass'] ?: props['automation/passScript']
final String proxyHost      = props['automation/proxyHost']
final String proxyPort      = props['automation/proxyPort']
final String proxyPass      = props['automation/proxyPass']
final String proxyUser      = props['automation/proxyUser']
final String workspace      = props['automation/workspace']

final String buildDefId     = props['buildDefId']
final String duration       = props['duration']
final String label          = props['label']
final String message        = props['message']
final String status         = props['status']

println "Server:\t" + server
println "Url:\t" + url
println "Status:\t" + status

//-------------------------------------------------------------------------
// Execute
//=========================================================================

ReportBuildStatus rbs = new ReportBuildStatus()
rbs.url = url
rbs.user = user
rbs.password = password
rbs.proxyHost = proxyHost
rbs.proxyPort = proxyPort
rbs.proxyPass = proxyPass
rbs.proxyUser = proxyUser
rbs.workspace = workspace

rbs.buildDefId = buildDefId
rbs.duration = duration
rbs.label = label
rbs.message = message
rbs.status = status

rbs.execute()