import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String server         = props['automation/rallyUrl']
final String base_url       = new URL(server).getHost()
final String url            = server + "/slm/webservice/" + props['automation/rallyVer']+"/"
final String user           = props['automation/rallyUser']
final String password       = props['automation/rallyPass'] ?: props['automation/passScript']
final String proxyHost      = props['automation/proxyHost']
final String proxyPort      = props['automation/proxyPort']
final String proxyPass      = props['automation/proxyPass']
final String proxyUser      = props['automation/proxyUser']
final String workspace      = props['automation/workspace']

final String defectPattern  = props['defectPattern']
final String taskPattern    = props['taskPattern']
final String usPattern      = props['usPattern']

if (!defectPattern && !taskPattern && !usPattern) {
    println "No patterns supplied for defects, tasks, or user stories. No comments will be added."
    System.exit(1)
}

println "Server:\t" + props['automation/rallyUrl']
println "Defect Pattern:\t" + defectPattern
println "Task Pattern:\t" + taskPattern
println "User Story Pattern:\t" + usPattern

//-------------------------------------------------------------------------
// Execute
//=========================================================================

PublishDefectReport pdr = new PublishDefectReport()
pdr.base_url = base_url
pdr.issueUrlBase = server
pdr.url = url
pdr.user = user
pdr.password = password
pdr.proxyHost = proxyHost
pdr.proxyPort = proxyPort
pdr.proxyPass = proxyPass
pdr.proxyUser = proxyUser
pdr.workspace = workspace

pdr.defectPattern = defectPattern
pdr.taskPattern = taskPattern
pdr.usPattern = usPattern

pdr.execute()