package com.urbancode.air.plugin.automation;

import com.urbancode.air.*
import org.apache.commons.httpclient.*
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.codec.*
import com.urbancode.commons.util.IO

public class CreateDefect extends AutomationBase {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    String projectKey
    String requirementKey
    String defectName
    String defectDesc
    String priority
    String severity
    String state
    String submitter
    String environment
    String build
    
    public void execute() {
        setupHttpClient()
        
        createDefect()
    }
    
    private void createDefect() {
        def workspaceRef = configureWorkspace()
        
        def projId
        def reqId
        
        if (projectKey && projectKey.length() > 0) {
          def projectMethod = new GetMethod(url + "project?workspace=" + URLEncoder.encode(workspaceRef, "UTF-8") + "&query=" +
              URLEncoder.encode("(Name = \"" + projectKey + "\")" ,"UTF-8") + "&" + URLEncoder.encode("fetch", "UTF-8") + "=" +
                  URLEncoder.encode("true", "UTF-8"))
          client.executeMethod(projectMethod)
          
          String responseText = IO.readText(projectMethod.getResponseBodyAsStream())
          projId = new XmlParser().parseText(responseText).Results.Object.ObjectID[0].text()
          if (projectMethod != null) {
             projectMethod.releaseConnection()
          }
        }
        else {
          def requirementMethod = new GetMethod(url + "hierarchicalrequirement?workspace=" + URLEncoder.encode(workspaceRef, "UTF-8") +
              "&query=" + URLEncoder.encode("(FormattedID = " + requirementKey + ")" ,"UTF-8") + "&" + URLEncoder.encode("fetch", "UTF-8") +
                  "=" + URLEncoder.encode("true", "UTF-8"))
          client.executeMethod(requirementMethod)
          
          String responseText = IO.readText(requirementMethod.getResponseBodyAsStream())
          reqId = new XmlParser().parseText(responseText).Results.Object.ObjectID[0].text()
          projId = new XmlParser().parseText(responseText).Results.Object.Project.'@ref'[0]
          if(requirementMethod != null) {
             requirementMethod.releaseConnection()
          }
        }
        // Generate XML doc
        def writer = new StringWriter()
        def builder = new groovy.xml.MarkupBuilder(writer)
        builder.Defect(){
          Project(projId)
          if (requirementKey && requirementKey.length() >0) {
            Requirement(reqId)
          }
          Description(defectDesc)
          Name(defectName)
          Priority(priority)
          Severity(severity)
          State(state)
          Owner(submitter)
          Environment(environment)
          FoundInBuild(build)
          //Workspace(workspaceRef)
        }
        
        HttpMethod method = new PostMethod(url + "defect/create")
        method.setRequestEntity((RequestEntity)new StringRequestEntity(writer.toString(), null, null));
        def result = client.executeMethod(method)
        def response = IO.readText(method.getResponseBodyAsStream())
        
        //check results
        def createResult = new XmlParser().parseText(response);
        def errors = createResult.Errors.OperationResultError.size();
        def warnings = createResult.Warnings.OperationResultWarning.size();
        
        if (errors == 0 && warnings == 0) {
          println "Successfully created defect! ObjectRef =" + createResult.Object.'@ref';
          System.exit 0
        }
        else {
          println "ERROR!!! Rally Server could not create defect! "
          createResult.Errors.OperationResultError.each { println it.text() }
          createResult.Warnings.OperationResultWarning.each { println it.text() }
          System.exit 1
        }
    }
}