import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String base_url       = new URL(props['automation/rallyUrl']).getHost()
final String version        = props['automation/rallyVer']
final String url            = props['automation/rallyUrl'] + "/slm/webservice/" + version +"/build/create"
final String user           = props['automation/rallyUser']
final String password       = props['automation/rallyPass'] ?: props['automation/passScript']
final String proxyHost      = props['automation/proxyHost']
final String proxyPort      = props['automation/proxyPort']
final String proxyPass      = props['automation/proxyPass']
final String proxyUser      = props['automation/proxyUser']
final String workspace      = props['automation/workspace']

final String buildDefId     = props['buildDefId']
final String duration       = props['duration']
final String label          = props['label']
final String message        = props['message']
final String status         = props['status']

println "Server:\t" + props['automation/rallyUrl']
println "Url:\t" + url
println "Status:\t" + status

//-------------------------------------------------------------------------
// Execute
//=========================================================================

ReportBuildStatus rbs = new ReportBuildStatus()
rbs.base_url = base_url
rbs.url = url
rbs.user = user
rbs.password = password
rbs.proxyHost = proxyHost
rbs.proxyPort = proxyPort
rbs.proxyPass = proxyPass
rbs.proxyUser = proxyUser
rbs.workspace = workspace
rbs.version = version

rbs.buildDefId = buildDefId
rbs.duration = duration
rbs.label = label
rbs.message = message
rbs.status = status

rbs.execute()