/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String server         = props['automation/rallyUrl']
final String url            = server + "/slm/webservice/v2.0/"
final String user         = props['automation/rallyUser']
final String password     = props['automation/rallyPass'] ?: props['automation/passScript']
final String proxyHost    = props['automation/proxyHost']
final String proxyPort    = props['automation/proxyPort']
final String proxyPass    = props['automation/proxyPass']
final String proxyUser    = props['automation/proxyUser']
final String workspace    = props['automation/workspace']

final String newValue     = props['newValue']
final String artifactKey  = props['artifactKey']
final String defectType   = props['type']
final String property     = props['property']

println "Server:\t" + server
println "Url:\t" + url
println "Artifact(s):\t" + artifactKey
println "Type:\t" + defectType
println "Property:\t" + property
println "New Value:\t" + newValue

//-------------------------------------------------------------------------
// Execute
//=========================================================================

ChangeArtifactProperty cap = new ChangeArtifactProperty()
cap.url = url
cap.user = user
cap.password = password
cap.proxyHost = proxyHost
cap.proxyPort = proxyPort
cap.proxyPass = proxyPass
cap.proxyUser = proxyUser
cap.workspace = workspace

cap.newValue = newValue
cap.artifactKey = artifactKey
cap.defectType = defectType
cap.property = property

cap.execute()