/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.plugin.automation.ScanApplication
import com.urbancode.air.plugin.automation.UploadReport


import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*


final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile


// Integration
final String path = stepProps['automation/path']
final String host = stepProps['automation/host']
final String tokenPath = stepProps['automation/tokenPath']
final String devEnvPath = stepProps['automation/devEnvPath']
final def acceptSSL = stepProps['automation/acceptSSL']?.toBoolean()

// for scan section
def type = stepProps['type']
def appName = stepProps['appName']
def scanPath = stepProps['scanPath']
def ozasmtFile = stepProps['ozasmtFile']
def htmlFile = stepProps['htmlFile']

// for report upload section
final String reportName = stepProps['reportName']
final String reportXml = ozasmtFile


ScanApplication step = new ScanApplication();
step.path = path;
step.host = host;
step.tokenPath = tokenPath;
step.devEnvPath = devEnvPath;
step.acceptSSL = acceptSSL;
step.type = type;
step.appName = appName;
step.scanPath = scanPath;
step.ozasmtFile = ozasmtFile;
step.htmlFile = htmlFile;
step.runScan()

UploadReport uploadStep = new UploadReport();
uploadStep.reportXml = reportXml;
uploadStep.reportName = reportName;
uploadStep.parseAndUploadResults()