/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.air.plugin.automation

import groovy.io.FileType;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;


import com.urbancode.air.*
import com.urbancode.commons.util.IO


public class RunScript {
    def path
    def scriptFile
    CommandHelper ch

    final def out = System.out
    final def workDir = new File('.').canonicalFile

    //----------------------------------------------------------------
    public RunScript() {
        ch = new CommandHelper(workDir);
    }

    //----------------------------------------------------------------
    public void runScript() {
        def cmdArgs = [path, 'script', scriptFile];

        try {
             ch.runCommand(cmdArgs.join(' '), cmdArgs);
        }
        catch (Exception e) {
            println ("Error executing script!");
            throw e;
        }
        println("Script Successfully completed");
    }
}