<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="text" encoding="utf-8"/>

    <xsl:template match="/AssessmentRun">
        <xsl:text> ----------------------------------------------------------------------------------&#x0A;</xsl:text>
        <xsl:text> Files Scanned: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_files"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text> Lines Scanned: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@line_total"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>     V-Density: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@vdensity"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text> ----------------------------------------------------------------------------------&#x0A;</xsl:text>
        <xsl:text>Total Findings: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_findings"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;    Vulnerabilities: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_high_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;       High: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_high_high_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;     Medium: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_high_med_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;        Low: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_high_low_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;Exceptions (Type 1): [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_med_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;       High: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_med_high_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;     Medium: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_med_med_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;        Low: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_med_low_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;Exceptions (Type 2): [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_low_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;       High: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_low_high_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;     Medium: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_low_med_finding"/>
        <xsl:text>]&#x0A;</xsl:text>

        <xsl:text>&#x09;&#x09;        Low: [</xsl:text>
        <xsl:value-of select="./AssessmentStats/@total_low_low_finding"/>
        <xsl:text>]&#x0A;</xsl:text>


        <xsl:text>----------------------------------------------------------------------------------&#x0A;</xsl:text>
        <xsl:text>Files with Scanning Errors:&#x0A;</xsl:text>
        <xsl:for-each select='//AssessmentFile[@error_status="1"]'>
            <xsl:text>&#x09;- </xsl:text>
            <xsl:value-of select="@filename"/>
            <xsl:text>&#x0A;</xsl:text>
        </xsl:for-each>

        <xsl:text>----------------------------------------------------------------------------------&#x0A;</xsl:text>
        <xsl:if test='count(//AssessmentFile/AssessmentStats[not(@total_high_finding=0)])'>
            <xsl:text>Files with High Importance Findings:&#x0A;</xsl:text>
        </xsl:if>
        <xsl:for-each select='//AssessmentFile/AssessmentStats[not(@total_high_finding="0")]'>
            <xsl:text>&#x09;</xsl:text>
            <xsl:value-of select="../@filename"/>
            <xsl:text> (</xsl:text>
            <xsl:value-of select="./@total_high_finding"/>
            <xsl:text>)</xsl:text>
            <xsl:text>&#x0A;</xsl:text>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>
