import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir                   = new File('.').canonicalFile
final def dateParser                = new DateParser();
final def apTool                    = new AirPluginTool(this.args[0], this.args[1]);

final def props                     = apTool.getStepProperties();
final File dir                      = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile
final def commandPath               = props['source/repo/commandPath'] ?: "scm"
final def serverUrl                 = props['source/repo/serverUrl']
final def username                  = props['source/repo/username']
final def password                  = props['source/repo/password']

final def workspace                 = props['source/workspace']
final def stream                    = props['source/stream']
final def baseline                  = props['source/baseline']
final def snapshot                  = props['source/snapshot']
final def components                = props['source/components']
final def buildSnapshot             = props['source/buildSnapshot']
final def buildSnapshotDescription  = props['source/buildSnapshotDescription']?:' '
final def listSnapshotDateFormat    = props['source/repo/listSnapshotDateFormat']
final def userExcludes              = props['source/excludeUsers'] ?: ''
final def fileFilters               = props['source/fileFilters'] ?: ''
final def isIncludeRoot             = Boolean.valueOf(props['source/isIncludeRoot'])
final def isForce                   = Boolean.valueOf(props['source/isForce'])

final def startBuildLifeId          = props['startBuildlifeId']
final String changesUrl             = props['changesUrl']

dir.mkdirs()

SCMChangelog changelog = new SCMChangelog()
changelog.command = commandPath
changelog.serverUrl = serverUrl
changelog.username = username
changelog.password = password
changelog.directory = dir

changelog.workspace = workspace
changelog.stream = stream
changelog.baseline = baseline
changelog.snapshot = snapshot
changelog.components = components
changelog.buildSnapshot = buildSnapshot
changelog.buildSnapshotDescription = buildSnapshotDescription
changelog.listSnapshotDateFormat = listSnapshotDateFormat
changelog.isIncludeRoot = isIncludeRoot
changelog.isForce = isForce

changelog.startBuildLifeId = startBuildLifeId
changelog.changesUrl = changesUrl

changelog.changeSetFilter.setUserExcludes(userExcludes)
changelog.changeSetFilter.setFileFilters(fileFilters)

changelog.execute()