import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir                   = new File('.').canonicalFile
final def dateParser                = new DateParser();
final def apTool                    = new AirPluginTool(this.args[0], this.args[1]);

final def props                     = apTool.getStepProperties();
final File dir                      = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile
final String srcName                = props['source'];
final def commandPath               = props['source/repo/commandPath'] ?: "scm"
final def serverUrl                 = props['source/repo/serverUrl']
final def username                  = props['source/repo/username']
final def password                  = props['source/repo/password'] ?: props['source/repo/passScript']

final def workspace                 = props['source/workspace']
final def stream                    = props['source/stream']
final def baseline                  = props['source/baseline']
final def snapshot                  = props['source/snapshot']
final def components                = props['source/components']
final def buildSnapshot             = props['source/buildSnapshot']
final def buildSnapshotDescription  = props['source/buildSnapshotDescription']?:' '
final def listSnapshotDateFormat    = props['source/repo/listSnapshotDateFormat']
final def userExcludes              = props['source/excludeUsers']?.readLines() ?: []
final def fileFilters               = props['source/fileFilters']?.readLines() ?: []
final def isIncludeRoot             = Boolean.valueOf(props['source/isIncludeRoot'])
final def isForce                   = Boolean.valueOf(props['source/isForce'])
final def buildLifeSnapshot         = props["buildlife/rtc.snapshot.${srcName}"]

dir.mkdirs()

SCMCheckout checkout = new SCMCheckout()
checkout.command = commandPath
checkout.serverUrl = serverUrl
checkout.username = username
checkout.password = password
checkout.directory = dir

checkout.workspace = workspace
checkout.stream = stream
checkout.baseline = baseline
checkout.snapshot = snapshot ? snapshot : buildLifeSnapshot
checkout.components = components
checkout.buildSnapshot = buildSnapshot
checkout.buildSnapshotDescription = buildSnapshotDescription
checkout.listSnapshotDateFormat = listSnapshotDateFormat
checkout.isIncludeRoot = isIncludeRoot
checkout.isForce = isForce

checkout.srcName = srcName

def newProps = checkout.execute()

newProps.each { name, value ->
    println "Updating properties on buildlife"
    apTool.setOutputProperty("buildlife/$name", value)
    println "";
}

apTool.storeOutputProperties()