/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.NaturalComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public final class CollectionUtil {
    @Deprecated
    public static <K2, V2, K1 extends K2, V1 extends V2> Map<K2, V2> reconstructMap(Map<K1, V1> map, Map<K2, V2> newMap) {
        newMap.putAll(map);
        return newMap;
    }

    public static <K, V> void reconstructMap(Map<K, V> map) {
        ArrayList<MapEntryClone<K, V>> entries = new ArrayList<MapEntryClone<K, V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entries.add(new MapEntryClone<K, V>(entry));
        }
        map.clear();
        if (map.size() != 0) {
            throw new IllegalStateException("Map does not appear to implement clear() method");
        }
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <T> void reconstructSet(Set<T> set) {
        Check.nonNull(set, "set");
        ArrayList<T> elements = new ArrayList<T>(set.size());
        elements.addAll(set);
        set.clear();
        if (set.size() != 0) {
            throw new IllegalStateException("Set does not appear to implement clear() method");
        }
        set.addAll(elements);
    }

    @Deprecated
    public static <T> Collection<? super T> addAll(Collection<? super T> collection, T[] array) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection for addAll() can not be null");
        }
        if (array != null) {
            Collections.addAll(collection, array);
        }
        return collection;
    }

    public static boolean containsAny(Collection<?> haystack, Collection<?> needles) {
        if (haystack != null && needles != null) {
            for (Object item : haystack) {
                if (!needles.contains(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> void retainAllGreater(Collection<T> collection, Comparator<? super T> comp, T value) {
        Iterator<T> itr = collection.iterator();
        while (itr.hasNext()) {
            T t = itr.next();
            if (comp.compare(value, t) < 0) continue;
            itr.remove();
        }
    }

    public static <T> void retainAllGreaterOrEqual(Collection<T> collection, Comparator<? super T> comp, T value) {
        Iterator<T> itr = collection.iterator();
        while (itr.hasNext()) {
            T t = itr.next();
            if (comp.compare(value, t) <= 0) continue;
            itr.remove();
        }
    }

    public static <T> void retainAllLess(Collection<T> collection, Comparator<? super T> comp, T value) {
        CollectionUtil.retainAllGreater(collection, Collections.reverseOrder(comp), value);
    }

    public static <T> void retainAllLessOrEqual(Collection<T> collection, Comparator<? super T> comp, T value) {
        CollectionUtil.retainAllGreaterOrEqual(collection, Collections.reverseOrder(comp), value);
    }

    public static <T extends Comparable<T>> void retainAllGreater(Collection<T> collection, T value) {
        CollectionUtil.retainAllGreater(collection, new NaturalComparator(), value);
    }

    public static <T extends Comparable<T>> void retainAllGreaterOrEqual(Collection<T> collection, T value) {
        CollectionUtil.retainAllGreaterOrEqual(collection, new NaturalComparator(), value);
    }

    public static <T extends Comparable<T>> void retainAllLess(Collection<T> collection, T value) {
        CollectionUtil.retainAllLess(collection, new NaturalComparator(), value);
    }

    public static <T extends Comparable<T>> void retainAllLessOrEqual(Collection<T> collection, T value) {
        CollectionUtil.retainAllLessOrEqual(collection, new NaturalComparator(), value);
    }

    public static <T> Set<T> copySet(Set<? extends T> set) {
        HashSet<Object> result = set == null ? new HashSet() : new HashSet<T>(set);
        return result;
    }

    public static <T> Set<T> nullableCopySet(Set<? extends T> set) {
        HashSet<? extends T> result = null;
        if (set != null) {
            result = new HashSet<T>(set);
        }
        return result;
    }

    public static <T> Set<T> immutableSet(Set<? extends T> set) {
        Set<Object> result = Collections.emptySet();
        if (set != null && !set.isEmpty()) {
            result = Collections.unmodifiableSet(CollectionUtil.copySet(set));
        }
        return result;
    }

    public static <T> Set<T> nullableImmutableSet(Set<? extends T> set) {
        Set<? extends T> result = null;
        if (set != null) {
            result = CollectionUtil.immutableSet(set);
        }
        return result;
    }

    public static <T> Set<T> copyOrderedSet(Set<? extends T> set) {
        LinkedHashSet<Object> result = set == null ? new LinkedHashSet() : new LinkedHashSet<T>(set);
        return result;
    }

    public static <T> Set<T> nullableCopyOrderedSet(Set<? extends T> set) {
        LinkedHashSet<? extends T> result = null;
        if (set != null) {
            result = new LinkedHashSet<T>(set);
        }
        return result;
    }

    public static <T> Set<T> immutableOrderedSet(Set<? extends T> set) {
        Set<Object> result = Collections.emptySet();
        if (set != null && !set.isEmpty()) {
            result = Collections.unmodifiableSet(CollectionUtil.copyOrderedSet(set));
        }
        return result;
    }

    public static <T> Set<T> nullableImmutableOrderedSet(Set<? extends T> set) {
        Set<? extends T> result = null;
        if (set != null) {
            result = CollectionUtil.immutableOrderedSet(set);
        }
        return result;
    }

    public static <T> List<T> copyList(List<? extends T> list) {
        ArrayList<Object> result = list == null ? new ArrayList() : new ArrayList<T>(list);
        return result;
    }

    public static <T> List<T> nullableCopyList(List<? extends T> list) {
        ArrayList<? extends T> result = null;
        if (list != null) {
            result = new ArrayList<T>(list);
        }
        return result;
    }

    public static <T> List<T> immutableList(List<? extends T> list) {
        List<Object> result = Collections.emptyList();
        if (list != null && !list.isEmpty()) {
            result = Collections.unmodifiableList(CollectionUtil.copyList(list));
        }
        return result;
    }

    public static <T> List<T> nullableImmutableList(List<? extends T> list) {
        List<? extends T> result = null;
        if (list != null) {
            result = CollectionUtil.immutableList(list);
        }
        return result;
    }

    public static <K, V> Map<K, V> copyMap(Map<? extends K, ? extends V> map) {
        LinkedHashMap<Object, Object> result = map == null ? new LinkedHashMap() : new LinkedHashMap<K, V>(map);
        return result;
    }

    public static <K, V> Map<K, V> nullableCopyMap(Map<? extends K, ? extends V> map) {
        LinkedHashMap<? extends K, ? extends V> result = null;
        if (map != null) {
            result = new LinkedHashMap<K, V>(map);
        }
        return result;
    }

    public static <K, V> Map<K, V> immutableMap(Map<? extends K, ? extends V> map) {
        Map<Object, Object> result = Collections.emptyMap();
        if (map != null && !map.isEmpty()) {
            result = Collections.unmodifiableMap(CollectionUtil.copyMap(map));
        }
        return result;
    }

    public static <K, V> Map<K, V> nullableImmutableMap(Map<? extends K, ? extends V> map) {
        Map<? extends K, ? extends V> result = null;
        if (map != null) {
            result = CollectionUtil.immutableMap(map);
        }
        return result;
    }

    public static <T> Collection<T> copyCollection(Collection<? extends T> collection) {
        ArrayList<Object> result = collection == null ? new ArrayList() : new ArrayList<T>(collection);
        return result;
    }

    public static <T> Collection<T> nullableCopyCollection(Collection<? extends T> collection) {
        ArrayList<? extends T> result = null;
        if (collection != null) {
            result = new ArrayList<T>(collection);
        }
        return result;
    }

    public static <T> Collection<T> immutableCollection(Collection<? extends T> collection) {
        Collection<Object> result = Collections.emptyList();
        if (collection != null && !collection.isEmpty()) {
            result = Collections.unmodifiableCollection(CollectionUtil.copyCollection(collection));
        }
        return result;
    }

    public static <T> Collection<T> nullableImmutableCollection(Collection<? extends T> collection) {
        Collection<? extends T> result = null;
        if (collection != null) {
            result = CollectionUtil.immutableCollection(collection);
        }
        return result;
    }

    public static <K, V> ConcurrentHashMap<K, V> createMapWithConcurrency(int concurrency) {
        return new ConcurrentHashMap(16, 0.75f, concurrency);
    }

    private CollectionUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static class MapEntryClone<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public MapEntryClone(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

