/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm


public class SCMLabel extends SCMStep {
    
    String description
    String baselineName
    
    public void execute() {
        createBaseLine()
    }
    
    public void createBaseLine() {
        def cmd = [command, '--non-interactive', 'create', 'baseline',
             '--overwrite-uncommitted',
             '-r', serverUrl,
             '-u', username,
             '-P', password,
             '--description', description ?: "",
             '--all', workspace, 
             baselineName]
        
        getCmdHelper().runCommand('Create baseline', cmd)
    }
}