/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir                   = new File('.').canonicalFile
final def dateParser                = new DateParser();
final def apTool                    = new AirPluginTool(this.args[0], this.args[1]);

final def props                     = apTool.getStepProperties();
final File dir                      = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile
final def commandPath               = props['source/repo/commandPath'] ?: "scm"
final def serverUrl                 = props['source/repo/serverUrl']
final def username                  = props['source/repo/username']
final def password                  = props['source/repo/password'] ?: props['source/repo/passScript']

final def workspace                 = props['source/workspace']

final def description               = props['message']
final def baselineName              = props['label']

dir.mkdirs()

SCMLabel label = new SCMLabel()
label.command = commandPath
label.serverUrl = serverUrl
label.username = username
label.password = password
label.directory = dir

label.workspace = workspace

label.description = description
label.baselineName = baselineName

label.execute()