/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm.changelog

import com.urbancode.air.plugin.scm.SCMChangelog

import java.text.SimpleDateFormat

public class ChangeSet {
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    final def RTC_CHANGELOG_OUT_DATE = new SimpleDateFormat(SCMChangelog.CHANGELOG_DATE_FORMAT)
    final def RTC_SCM_HISTORY_OUT_DATE = new SimpleDateFormat('dd-MMM-yyyy hh:mm a')

    String user = null
    String message = null
    Date date = null
    final Set<ChangeSetFileEntry> fileSet = []
    Map<String,String> properties = [:]
    
    public ChangeSet(String user, String message, String date) {
        this.user = user?.trim()
        this.message = message?.trim()
        this.date = RTC_CHANGELOG_OUT_DATE.parse(date)
    }
    
    public boolean hasAllowedPath(ChangeSetFilter changeSetFilter) {
        return fileSet.find{ changeSetFilter.pathIsIncluded(it.path) } != null
    }
    
    public boolean hasAllowedAuthor(ChangeSetFilter changeSetFilter) {
        return changeSetFilter.authorIsIncluded(user);
    }

    public void setDate(String date) {
        this.date = RTC_SCM_HISTORY_OUT_DATE.parse(date)
    }
}
