/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;

@BridgeMethodsAdded
public class JavascriptUtil {
    public static String escapeJs(String s) {
        if (s == null) {
            throw new IllegalArgumentException("The parameter s must be non-null.");
        }
        char[] chars = s.toCharArray();
        StringBuffer result = new StringBuffer(chars.length);
        for (char c : chars) {
            result.append(JavascriptUtil.escapeChar(c));
        }
        return result.toString();
    }

    public static char[] escapeChar(char c) {
        if (c != '\'' && c != '\"' && c != '<' && c != '>') {
            if (c == '\b') {
                return new char[]{'\\', 'b'};
            }
            if (c == '\f') {
                return new char[]{'\\', 'f'};
            }
            if (c == '\n') {
                return new char[]{'\\', 'n'};
            }
            if (c == '\u0000') {
                return new char[]{'\\', 'O'};
            }
            if (c == '\r') {
                return new char[]{'\\', 'r'};
            }
            if (c == '\t') {
                return new char[]{'\\', 't'};
            }
            if (c == '\u000b') {
                return new char[]{'\\', 'v'};
            }
            if (c == '\\') {
                return new char[]{'\\', '\\'};
            }
            if (c >= ' ' && c < '\u007f') {
                return new char[]{c};
            }
        }
        String hex = Integer.toHexString(c).toUpperCase();
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        char[] result = new char[hex.length() + 2];
        result[0] = 92;
        result[1] = 117;
        hex.getChars(0, hex.length(), result, 2);
        return result;
    }
}

