import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.SimpleDateFormat


final def workDir                   = new File('.').canonicalFile
final def dateParser                = new DateParser();
final def apTool                    = new AirPluginTool(this.args[0], this.args[1]);

final def props                     = apTool.getStepProperties();
final File dir                      = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile
final def commandPath               = props['source/repo/commandPath'] ?: "scm"
final def serverUrl                 = props['source/repo/serverUrl']
final def username                  = props['source/repo/username']
final def password                  = props['source/repo/password']

final def srcName                   = props['source']
final def workspace                 = props['source/workspace']
final def stream                    = props['source/stream']
final def baseline                  = props['source/baseline']
final def snapshot                  = props['source/snapshot']
final def components                = props['source/components']
final def buildSnapshot             = props['source/buildSnapshot']
final def buildSnapshotDescription  = props['source/buildSnapshotDescription']?:' '
final def listSnapshotDateFormat    = props['source/repo/listSnapshotDateFormat']
final def userExcludes              = props['source/excludeUsers']?.readLines() ?: []
final def fileFilters               = props['source/fileFilters']?.readLines() ?: []
final def isIncludeRoot             = Boolean.valueOf(props['source/isIncludeRoot'])
final def isForce                   = Boolean.valueOf(props['source/isForce'])

final def startDate                 = dateParser.parseDate(props['startDate'])

println "Start Date: " + startDate

dir.mkdirs()

SCMQuietPeriod qp = new SCMQuietPeriod()
qp.command = commandPath
qp.serverUrl = serverUrl
qp.username = username
qp.password = password
qp.directory = dir

qp.workspace = workspace
qp.stream = stream
qp.baseline = baseline
qp.snapshot = snapshot
qp.components = components
qp.buildSnapshot = buildSnapshot
qp.buildSnapshotDescription = buildSnapshotDescription
qp.listSnapshotDateFormat = listSnapshotDateFormat
qp.isIncludeRoot = isIncludeRoot
qp.isForce = isForce

qp.startDate = startDate
qp.dateParser = dateParser

def latestDate = qp.execute()

if (latestDate == null) {
    println('No changes detected')
}
else {
    apTool.setOutputProperty("job/latest.change.time.${srcName}", String.valueOf(latestDate.time))
    apTool.storeOutputProperties()
    println "Latest Revision Date: " + latestDate
}
