import com.urbancode.air.*
import com.urbancode.air.plugin.reportpublisher.FileSet
import com.urbancode.air.plugin.reportpublisher.UploadHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

//props.each { prop ->
//  println prop;
//}
//System.exit 1

final def reportName        = props['reportName']
final def sourceDir         = new File('.').canonicalFile
final def includes          = props['includes']
final def excludes          = props['excludes']
final def jobId             = String.valueOf(System.getenv("JOB_ID"))

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def fileSet = new FileSet(sourceDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    def reportFiles = fileSet.files()
    println 'Base Directory: ' +  sourceDir.getAbsolutePath()
    println 'Include File Patterns: ' + includes
    println 'Exclude File Patterns: ' + excludes
    
    reportFiles.each { file ->
        println 'Files identified to be uploaded as a report: ' + file
    }
    
    def uploadHelper = new UploadHelper()
    uploadHelper.uploadResult(reportFiles, reportName, jobId)
}
catch (e) {
    println e
    System.exit 1
}
