/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileListerBase;
import com.urbancode.commons.fileutils.filelister.FileListerFactory;
import com.urbancode.commons.fileutils.filelister.FileMatcher;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.io.IOException;

final class FileListerIncludeNonEmptyFollow
extends FileListerBase {
    static final FileListerFactory FACTORY = new FileListerFactory(){

        public FileListerIncludeNonEmptyFollow create(File base, FileMatcher scanner, PermissionReader permissionReader) throws IOException {
            return new FileListerIncludeNonEmptyFollow(base, scanner, permissionReader);
        }

        public String implementationName() {
            return FileListerIncludeNonEmptyFollow.class.getName();
        }
    };

    FileListerIncludeNonEmptyFollow(File base, FileMatcher scanner, PermissionReader permissionReader) throws IOException {
        super(base, scanner, permissionReader);
    }

    protected boolean includeInList(TypedFile file) {
        File actualFile = file.translate(this.base());
        if (actualFile.isFile()) {
            return true;
        }
        String[] files = actualFile.list();
        return files != null && files.length > 0;
    }

    protected boolean isTraversable(TypedFile file) {
        return file.translate(this.base()).isDirectory();
    }

    protected TypedFile normalize(TypedFile file) throws IOException {
        if (file.type() == FileType.SYMLINK) {
            return TypedFile.createNoSymlinks(this.base(), file.path(), this.getPermissions(file));
        }
        return file;
    }
}

