/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.analytics.*;

final def apTool = new AirPluginTool(args[0], args[1])
final def workDir = new File('.').canonicalFile
final def out = System.out

//------------------------------------------------------------------------------
// Execution
//------------------------------------------------------------------------------
final def props                 = apTool.getStepProperties()
final def includes              = props['includes']
final def excludes              = props['excludes']
final def reportName            = props['reportName'] ?: 'Sonargraph Report'
final def includeDescription    = Boolean.valueOf(props['includeDescription'])
final def onlySummaryCounts     = Boolean.valueOf(props['onlySummaryCounts'])

try {
    def fileSet = new FileSet(workDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    if (includes) {
        println "Reporting on all files in ${includes}"
    }
    if (excludes) {
        println "Excluding files in ${excludes}"
    }
    
    def reportFiles = fileSet.files()
    reportFiles.each { file->
        println 'Report File identified to be included in the Sonargraph Report: ' + file
    }
    
    if (reportFiles.size() > 0) {
        def xmlHelper = new XmlHelper()
        if (onlySummaryCounts) {
            xmlHelper.uploadSummariesOnly(reportFiles, reportName, includeDescription)
        }
        else {
            xmlHelper.uploadResult(reportFiles, reportName, includeDescription)
        }
    }
    else {
        println 'No report files found to upload'
    }
}
catch (Exception e) {
    println e
    System.exit 1
}
