/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs.hash;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.crypto.algs.hash.AbstractHashAlgorithm;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@BridgeMethodsAdded
public class PBKDF2WithHmacSHA1Alg
extends AbstractHashAlgorithm {
    private static final int SALT_LENGTH = SALT_128_bit;
    private static final int ROUNDS = 1024;
    private static final char SEPARATOR_CHAR = '|';

    public String getAlgPrefix() {
        return "pbkdf2";
    }

    public boolean isSupported() {
        try {
            SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public String encode(String value) throws GeneralSecurityException {
        return this.encode0(value);
    }

    public boolean validate(String plainText, String cipherText) throws GeneralSecurityException {
        int saltEnd = cipherText.indexOf(124);
        int roundEnd = cipherText.indexOf(124, saltEnd + 1);
        String salt64 = cipherText.substring(0, saltEnd);
        int rounds = Integer.valueOf(cipherText.substring(saltEnd + 1, roundEnd));
        byte[] salt = this.decodeBase64(salt64);
        String encoded = this.encode0(salt, rounds, plainText);
        return cipherText.equals(encoded);
    }

    protected String encode0(String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            byte[] salt = this.randomSalt(SALT_LENGTH);
            result = this.encode0(salt, 1024, value);
        } else {
            result = null;
        }
        return result;
    }

    protected String encode0(byte[] salt, int rounds, String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            char[] data = value.toCharArray();
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec ks = new PBEKeySpec(data, salt, rounds, 128);
            SecretKey s = f.generateSecret(ks);
            byte[] hash = s.getEncoded();
            result = this.encodeBase64String(salt) + '|' + rounds + '|' + this.encodeBase64String(hash);
        } else {
            result = null;
        }
        return result;
    }
}

