
final def DATE_READ_1 = new java.text.SimpleDateFormat("E MMM dd HH:mm:ss zzz yyyy") // java.util.Date.toString()
final def DATE_READ_2 = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") // ISO-like format

final def isValidDate = {dateString ->
  boolean valid = false

  if (dateString.isLong() || dateString.startsWith('${')) {
    // is dynamic or is milliseconds since epoch, valid
    valid = true;
  }
  else {
    [DATE_READ_1, DATE_READ_2].each{format ->
        try {
            format.parse(dateString)
            valid = true
        }
        catch (java.text.ParseException e) {
            // not a match for this format
        }
    }
  }
  return valid;
}

// VALIDATE START/END DATE/REVISION FORMATTING
  
if (startDate && !startDate.startsWith('${')) {
  if (!isValidDate(startDate)) {
    errors.startDate = 'Date did not fit format'
  }
}

if (endDate && !endDate.startsWith('${')) {
  if (!isValidDate(endDate)) {
    errors.endDate = 'Date did not fit format'
  }
}

if (startRevision && !startRevision.startsWith('${')) {
    // validate revision is a number
    if (!startRevision.isLong()) {
        errors.startRevision = 'startRevision must be a whole number'
    }
}

if (endRevision && !endRevision.startsWith('${')) {
    // validate endRevision is a number
    if (!endRevision.isLong()) {
        errors.endRevision = 'endRevision must be a whole number'
    }
}

// VALIDATE START/END COMBINATIONS

if (startDate && startRevision) {
    if (!startDate.startsWith('${') || !startRevision.startsWith('${')) {
        errors.startDate = 'startDate and startRevision can not both be specified'
        errors.startRevision = 'startDate and startRevision can not both be specified'
    }
}

if (endDate && endRevision) {
    if (!endDate.startsWith('${') || !endRevision.startsWith('${')) {
        errors.endDate = 'endDate and endRevision can not both be specified'
        errors.endRevision = 'endDate and endRevision can not both be specified'
    }
}    
    
// VALIDATE FILTERS

if (fileFilters) {
  // check each non-empty line
  for (filter in fileFilters.readLines().collect{it.trim()}.findAll{it}) {
    if (!filter.startsWith('+') && !filter.startsWith('-')) {
      errors.fileFilters = 'All file filters must start with either + or -'
      break
    }
  }
}
