import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir = new File('.').canonicalFile
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def dateParser = new DateParser()

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS 
//------------------------------------------------------------------------------
final def props = apTool.getStepProperties()

final def svnExe                = props['source/repo/commandPath'] ?: "svn"
final def svnRoot               = props['source/repo/repositoryBaseUrl']
final def username              = props['source/repo/username']
final def password              = props['source/repo/password'] ?: props['source/repo/passScript']
final def svnTrunk              = props['source/projectTrunkPath']
//final def svnBranches         = props['source/projectBranchesPath']
//final def svnTags             = props['source/projectTagsPath']
final def srcName               = props['source'];
final def dir                   = new File(workDir, props['source/dirOffset'] ?: '.')

//final def fromBranch          = props['fromBranch']
//final def fromTag             = props['fromTag']
final def revision              = props['revision']
final def date                  = dateParser.parseDate(props['date'])

final boolean doExport          = Boolean.valueOf(props['source/export'])
final boolean ignoreExternals   = Boolean.valueOf(props['source/ignoreExternals'])
//final boolean clean           = props['cleanWorkspace']?.toBoolean()

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------
dir.mkdirs()

SCMCheckout co = new SCMCheckout()
co.scmCommand = svnExe
co.username = username
co.password = password
co.directory = dir
co.doExport = doExport
co.ignoreExternals = ignoreExternals
//co.fromBranch = fromBranch
//co.fromTag = fromTag
//co.svnBranches = svnBranches
//co.svnTags = svnTags
co.svnTrunk = svnTrunk
co.baseUrl = svnRoot
co.revision = revision
co.date = date

co.execute()

if (co.revision) {
    println "Updating workspace revision on buildlife to $co.revision"
    apTool.setOutputProperty("buildlife/workspace.revision.$srcName", co.revision)
    println "";
}
else if (co.date) {
    println "Updating workspace date on buildlife to $co.date"
    apTool.setOutputProperty("buildlife/workspace.date.$srcName", String.valueOf(co.date.time))
    println "";
}

apTool.storeOutputProperties()