package com.urbancode.air.plugin.scm

import com.urbancode.air.*

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SCMTag extends SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    String revision;
    /*
    String fromBranch;
    String fromTag;
    String svnBranches;
    */
    String svnTags;
    
    String svnTrunk;
    String baseUrl;
    String message;
    //String createBranch;
    String createTag;
    Date date;
    
    // Create date to format output later
    private SimpleDateFormat SVN_DATE

    /**
     *
     */
    public void execute() {
        cleanPaths()
        
        SVN_DATE = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z")
        SVN_DATE.timeZone = TimeZone.getTimeZone("GMT")
        
        def command = [scmCommand, '--non-interactive', '--no-auth-cache', 'copy']

        if (username) {
            command << '--username' << username
            if (password) {
                command << '--password' << password
            }
        }
        
        command << '--message' << message
        
        // label from sourceurl
        if (revision) {
            command << '--revision' << revision
        }
        else if (date) {
            command << '--revision' << ('{'+SVN_DATE.format(date)+'}')
        }
        
        /*
        if (fromBranch) {
            command.add(baseUrl+'/'+svnBranches+'/'+fromBranch)
        }
        else if (fromTag) {
            command.add(baseUrl+'/'+svnTags+'/'+fromTag)
        }
        else {
            command.add(baseUrl+'/'+svnTrunk)
        }
        
        // destination url
        if (createBranch) {
            command.add(baseUrl+'/'+svnBranches+'/'+createBranch)
        }
        else if (createTag) {
            command.add(baseUrl+'/'+svnTags+'/'+createTag)
        }
        else {
            throw new IllegalStateException() // shouldn't happen
        }
        */
        
        command.add(baseUrl+'/'+svnTrunk)
        command.add(baseUrl+'/'+svnTags+'/'+createTag)
        cmdHelper.runCommand("Creating SVN Remote Label", command)
    }
    
    public void cleanPaths() {
        if (baseUrl) {
            baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl
        }
        
        if (svnTrunk) {
            svnTrunk = svnTrunk.startsWith("/") ? svnTrunk.substring(1) : svnTrunk
            svnTrunk = svnTrunk.endsWith("/") ? svnTrunk.substring(0, svnTrunk.length() - 1) : svnTrunk
        }
        
        if (svnTags) {
            svnTags = svnTags.startsWith("/") ? svnTags.substring(1) : svnTags
            svnTags = svnTags.endsWith("/") ? svnTags.substring(0, svnTags.length() - 1) : svnTags
        }
        
        /*
        if (svnBranches) {
            svnBranches = svnBranches.startsWith("/") ? svnBranches.substring(1) : svnBranches
            svnBranches = svnBranches.endsWith("/") ? svnBranches.substring(0, svnBranches.length() - 1) : svnBranches
        }
        
        if (fromBranch) {
            fromBranch = fromBranch.startsWith("/") ? fromBranch.substring(1) : fromBranch
            fromBranch = fromBranch.endsWith("/") ? fromBranch.substring(0, fromBranch.length() - 1) : fromBranch
        }
        
        if (fromTag) {
            fromTag = fromTag.startsWith("/") ? fromTag.substring(1) : fromTag
            fromTag = fromTag.endsWith("/") ? fromTag.substring(0, fromTag.length() - 1) : fromTag
        }
        */
    }
}
