import java.text.SimpleDateFormat
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def dateParser = new DateParser()
final def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def props = apTool.getStepProperties()
final def workDir = new File(".").canonicalFile

final String scmCmd       = props['source/repo/commandPath'] ?: "svn"
final String baseUrl      = props['source/repo/repositoryBaseUrl']
final String username     = props['source/repo/username']
final String password     = props['source/repo/password'] ?: props['source/repo/passScript']
final boolean isSvnRepo   = Boolean.valueOf(props['source/repo/isSvnRepo'])

final File dir            = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile
final def svnTrunk        = props['source/projectTrunkPath']

final def startRevision   = props['startRevision']
final def endRevision     = props['endRevision']
final def startDate       = dateParser.parseDate(props['startDate']) // TODO fallback to property:workspace.date?
final def endDate         = dateParser.parseDate(props['endDate']) // TODO fallback to property:workspace.date?
final String changesUrl   = props['changesUrl']

def userExcludes          = props['source/excludeUsers'] ?: ""
def fileFilters           = props['source/fileFilters'] ?: ""

println "Getting Subversion Source Changes"
println "Ignoring Users: " + userExcludes
println "Ignoring Changes To: " + fileFilters
println ""

//
// Perform step
//
dir.mkdirs()

SCMChangelog changelog = new SCMChangelog()
changelog.scmCommand = scmCmd
changelog.username = username
changelog.password = password
changelog.directory = dir

changelog.startRevision = startRevision
changelog.endRevision = endRevision
changelog.startDate = startDate
changelog.endDate = endDate
changelog.svnTrunk = svnTrunk
changelog.svnRoot = baseUrl
changelog.changesUrl = changesUrl
changelog.isSvnRepo = isSvnRepo

changelog.changeSetFilter.setUserExcludes(userExcludes)
changelog.changeSetFilter.setFileFilters(fileFilters)

changelog.execute()
