/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm;

import com.urbancode.air.*

import java.io.File;
import java.util.Date;

abstract public class SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    static protected final SCMHelper scmHelper = new SCMHelper();
    static protected final String REPO_TYPE = "svn";

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    def out = System.out;

    String scmCommand = "svn";
    String username = null;
    String password = null;
    File directory;

    CommandHelper cmdHelper = new CommandHelper(directory)

    public void println(String msg) {
        out.println(msg);
    }
}
