/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*

import java.text.*;
import java.util.Date;

public class SCMCheckout extends SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    String revision;
    /*
    String fromBranch;
    String fromTag;
    String svnBranches;
    String svnTags;
    */
    String svnTrunk;
    String baseUrl;
    Date date;
    boolean doExport;
    boolean ignoreExternals;
    // Create date to format output later
    private SimpleDateFormat SVN_DATE
    
    /**
     *
     */
    public void execute() {
        SVN_DATE = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z")
        SVN_DATE.timeZone = TimeZone.getTimeZone("GMT")
        cleanPaths()
        
        directory.mkdirs();
        
        def command = [scmCommand, '--non-interactive', '--no-auth-cache']
        
        if (doExport) {
            command << 'export' << '--force' // need force because target directory does/may exist
        }
        else {
            command << 'checkout'
        }
        
        if (ignoreExternals) {
            command << "--ignore-externals"
        }
        
        if (username) {
            command << '--username' << username
            if (password) {
                command << '--password' << password
            }
        }
        
        if (revision) {
            command << '--revision' << revision
        }
        else if (date) {
            command << '--revision' << ('{'+SVN_DATE.format(date)+'}')
        }
        else {
            println "Neither revision nor date specified for checkout"
        }
        
        /*
        if (fromBranch) {
            command << (baseUrl+'/'+svnBranches+'/'+fromBranch)
        }
        else if (fromTag) {
            command << (baseUrl+'/'+svnTags+'/'+fromTag)
        }
        else {
            command << (baseUrl+'/'+svnTrunk)
        }
        */
        
        command << (baseUrl+'/'+svnTrunk)
        command << directory.path // check out to workDir
        cmdHelper.runCommand('Checkout', command)
    }
    
    public void cleanPaths() {
        if (baseUrl) {
            baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl
        }
        
        if (svnTrunk) {
            svnTrunk = svnTrunk.startsWith("/") ? svnTrunk.substring(1) : svnTrunk
            svnTrunk = svnTrunk.endsWith("/") ? svnTrunk.substring(0, svnTrunk.length() - 1) : svnTrunk
        }
        
        /*
        if (svnBranches) {
            svnBranches = svnBranches.startsWith("/") ? svnBranches.substring(1) : svnBranches
            svnBranches = svnBranches.endsWith("/") ? svnBranches.substring(0, svnBranches.length() - 1) : svnBranches
        }
        
        if (svnTags) {
            svnTags = svnTags.startsWith("/") ? svnTags.substring(1) : svnTags
            svnTags = svnTags.endsWith("/") ? svnTags.substring(0, svnTags.length() - 1) : svnTags
        }
        
        if (fromBranch) {
            fromBranch = fromBranch.startsWith("/") ? fromBranch.substring(1) : fromBranch
            fromBranch = fromBranch.endsWith("/") ? fromBranch.substring(0, fromBranch.length() - 1) : fromBranch
        }
        
        if (fromTag) {
            fromTag = fromTag.startsWith("/") ? fromTag.substring(1) : fromTag
            fromTag = fromTag.endsWith("/") ? fromTag.substring(0, fromTag.length() - 1) : fromTag
        }
        */
    }
}