/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*

final def workDir = new File('.').canonicalFile
final def CommandHelper ch = new CommandHelper(workDir)
final def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS 
//------------------------------------------------------------------------------
def props = apTool.getStepProperties()

final def svnExe       = 'svn' // if we wish to add a `svn status` call for pruning unvesioned files (and reverting changed ones?)
final def dir          = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile // get checkout directory

//------------------------------------------------------------------------------
// PREPARE WORKING DIRECTORY
//------------------------------------------------------------------------------

// create the working directory
dir.mkdirs()
if (!dir.exists()) {
    throw new Exception("Could not create working directory ${workDir}")
}
else if (dir.isFile()) {
    throw new Exception("Specified working directory is a file!! ${workDir}")
}

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------

println "Deleting directory contents for $dir"
dir.listFiles().each{ file ->
    boolean success = false;
    if (file.isFile()) {
        success = file.delete()
    }
    else if (file.isDirectory()){
        success = file.deleteDir()
    }
    if (!success) {
        println("Failed to delete $file")
    }
}
println "Done deleting directory contents for $dir"