/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm.changelog

public class ChangeSet {
    //**************************************************************************
    // CLASS
    //**************************************************************************
    
    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    String id= null;
    String user = null;
    String message = null;
    Date date = null;
    final Set<ChangeSetFileEntry> fileSet = [];
    Map<String,String> properties = [:];
    
    public boolean hasAllowedPath(ChangeSetFilter changeSetFilter, String copyFromPath) {
        return fileSet.find{ changeSetFilter.pathIsIncluded(it.path, copyFromPath) } != null;
    }
    
    public boolean hasAllowedAuthor(ChangeSetFilter changeSetFilter) {
        return changeSetFilter.authorIsIncluded(user);
    }
}