/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.text.SimpleDateFormat
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir = new File('.').canonicalFile
final def dateParser = new DateParser()
final def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS AND VALIDATE
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def svnExe       = props['source/repo/commandPath'] ?: "svn"
final def svnRoot      = props['source/repo/repositoryBaseUrl']
final def username     = props['source/repo/username']
final def password     = props['source/repo/password'] ?: props['source/repo/passScript']
final def svnTrunk     = props['source/projectTrunkPath']
//final def svnBranches  = props['source/projectBranchesPath']
final def svnTags      = props['source/projectTagsPath']

//final def fromBranch   = props['fromBranch']
//final def fromTag      = props['fromTag']
final def revision     = props['revision'] ?: props['buildlife/workspace.revision.$srcName']
final def date         = dateParser.parseDate(props['date'] ?: props['workspace.date'])

//final def createBranch = props['createBranch']
final def createTag    = props['label']
final def message      = props['message']

final File dir         = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile

//
// Perform step
//
dir.mkdirs()

SCMTag tag = new SCMTag()
tag.scmCommand = svnExe
tag.username = username
tag.password = password
tag.directory = dir
/*
tag.fromBranch = fromBranch
tag.fromTag = fromTag
tag.svnBranches = svnBranches
*/
tag.svnTags = svnTags

tag.svnTrunk = svnTrunk
tag.baseUrl = svnRoot
tag.revision = revision
tag.date = date

//tag.createBranch = createBranch
tag.createTag = createTag
tag.message = message

tag.execute()