/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm;

import java.text.*;
import java.util.Date;


public class SCMHelper {

    static public final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";

    public DateFormat getDateFormatter() {
        return new SimpleDateFormat(DATE_FORMAT)
    }

    public String formatDate(Date date) {
        return !date ? null : getDateFormatter().format(date);
    }

    public String formatDateRange(Date since, Date until) {
        def f = this.getDateFormatter();
        
        assert since : "A since date for range must be specified"
        assert until : "A until date for range must be specified"
        
        return "${f.format(until)}-${f.format(since)}";
    }
}