/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*
import com.urbancode.air.plugin.scm.changelog.*

import java.util.Date;
import java.util.TimeZone;
import java.text.SimpleDateFormat


public class SCMQuietPeriod extends SCMChangelog {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    /**
     *
     * @return date of the last change
     */
    public def execute() {
        SVN_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z")
        SVN_DATE.timeZone = TimeZone.getTimeZone("GMT")
        
        SVN_DATE_OUT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'")
        SVN_DATE_OUT_FORMAT.timeZone = TimeZone.getTimeZone("GMT")
        
        directory.mkdirs();
        
        println "Validating revisions"
        validate()
        
        initCheckoutPath();
        
        parseTrueOffset()
        
        // Get Change Log Output
        def logOutput = runLogCommand()
        List<ChangeSet> changeSets = parseLogIntoChangeSets(logOutput)
        Date latestDate = changeSets.collect{ChangeSet cs -> cs.date}.max();
        return latestDate
    }
}
