package com.urbancode.air.plugin.automation

import com.urbancode.air.*


public class ChangeDefectStatus extends AutomationBase {
    
    //*********************************************************************************************
    // CLASS
    //*********************************************************************************************
    
    //*********************************************************************************************
    // INSTANCE
    //*********************************************************************************************
    
    String workItemIds
    String state
    String reason
    
    public void execute() {
        changeDefectStatus()
    }
    
    public void changeDefectStatus() {
        try {
            def foundErrors = false
            workItemIds.split(',').each {
                def exe = System.getenv("PLUGIN_HOME") + "${fileSep}lib${fileSep}tftool" + tfsVersion + ".exe"
                def command = [exe, 'resolve', "/server:$serverUrl"]
        
                if (serverUserName && serverPassword) {
                    command << "/user:$serverUserName"
                    command << "/password:$serverPassword"
                }
        
                command << "/id:${it.trim()}"
                command << "/state:$state"
                command << "/reason:$reason"
                try {
                    ch.runCommand("Changing state for work item $it", command)
                }
                catch (Exception e) {
                    println "Error changing state for work item: $it"
                    foundErrors = true
                }
            }
        
            if (workItemIds.split(',').size() == 0) {
                println 'No work items provided!'
            }
        
            if (foundErrors) {
                System.exit 1
            }
        }
        catch (Throwable t) {
            t.printStackTrace()
            System.exit 1
        }
    }
}