/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.automation

import com.urbancode.air.*


public class CreateDefect extends AutomationBase {
    
    //=============================================================================================
    // CLASS
    //=============================================================================================
    
    //=============================================================================================
    // INSTANCE
    //=============================================================================================
    
    String issueProject
    String type
    String title
    String assignedTo
    String description
    
    public void execute() {
        createDefect()
    }
    
    public void createDefect() {
        def exe = System.getenv("PLUGIN_HOME") + "${fileSep}lib${fileSep}tftool" + tfsVersion + ".exe"
        def command = [exe, 'create', "/server:$serverUrl"]
        
        if (serverUserName && serverPassword) {
            command << "/user:$serverUserName"
            command << "/password:$serverPassword"
        }
    
        command << "/project:$issueProject"
        command << "/type:$type"
        command << "/title:$title"
    
        if (description) {
            command << "/description:$description"
        }
        
        if (assignedTo) {
            command << "/assignTo:$assignedTo"
        }
    
        ch.runCommand('Creating work item', command)
    }
}