/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

final String serverUrl = props['automation/serverUrl']
final String serverUserName = props['automation/serverUserName']
final String serverPassword = props['automation/serverPassword']
final String tfsVersion = props['automation/tfsVersion']

final String workItemRegex = props['workItemRegex'] ?: ".*"

PublishDefectReport pdr = new PublishDefectReport()
pdr.serverUrl = serverUrl
pdr.serverUserName = serverUserName
pdr.serverPassword = serverPassword
pdr.tfsVersion = tfsVersion

pdr.workItemRegex = workItemRegex

pdr.execute()