/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile

final def dateParser = new DateParser();
final def apTool = new AirPluginTool(args[0], args[1]);

final def props = apTool.getStepProperties();

final def dirOffset             = props['source/dirOffset'] ?: '.'
final def dir                   = new File(workDir, dirOffset).canonicalFile // get checkout directory
final def scmCmd                = props['source/repo/commandPath'] ?:'tf'
final def serverUrl             = props['source/repo/serverUrl']
final def serverUserName        = props['source/repo/userName']
final def serverUserPassword    = props['source/repo/password'] ?: props['source/repo/passScript']
final def sourceLocation        = props['source/sourceLocation']
final def workspaceName         = props['source/workspaceName']
final def srcName               = props['source']
final def label                 = props['source/label']
final def changeset             = props['source/changeset']
final def createWorkspace       = Boolean.valueOf(props['source/createWorkspace'])
final def forceGet              = Boolean.valueOf(props['source/forceGet'])
final def date                  = props['date'] != null ? dateParser.parseDate(props['date']) : null
final def blDate                = dateParser.parseDate(props['workspace.date.$srcName'])

//------------------------------------------------------------------------------
// RUN CHECKOUT
//------------------------------------------------------------------------------
dir.mkdirs()

SCMCheckout co = new SCMCheckout()
co.scmCommand = scmCmd
co.workDir = dir
co.dirOffset = dirOffset
co.serverUrl = serverUrl
co.serverUserName = serverUserName
co.serverPassword = serverUserPassword
co.sourceLocation = sourceLocation

co.label = label
co.changeset = changeset
co.workspaceName = workspaceName
co.createWorkspace = createWorkspace
co.forceGet = forceGet
co.date = date

co.execute()

if (co.date) {
    if (blDate != co.date) {
        println "Updating workspace date on buildlife to $co.date"
        apTool.setOutputProperty("buildlife/workspace.date.$srcName", String.valueOf(co.date))
        println "";
    }
}

apTool.storeOutputProperties()
