#!/usr/bin/env groovy

import com.urbancode.anthill3.AHPTool
import com.urbancode.anthill3.CommandHelper

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
try {
    final def workDir = new File('.').canonicalFile

    final def ahpTool = new AHPTool();

    final def props = ahpTool.getStepProperties();
    final def serverUrl = props['repo/serverUrl']
	final def serverUserName = props['repo/userName']
	final def serverPassword = props['repo/password']
	final def tfsVersion = props['repo/serverVersion']
	final def workItemIds = props['workItemIds']?:''
	final def state = props['state']
	final def reason = props['reason']

    def foundErrors = false
    workItemIds.split(',').each {
        // run tftool command
        def command = ['tftool' + tfsVersion + '.exe', 'resolve', "/server:$serverUrl"]

        if (serverUserName && serverPassword) {
            command << "/user:$serverUserName"
            command << "/password:$serverPassword"
        }

        command << "/id:${it.trim()}"
        command << "/state:$state"
        command << "/reason:$reason"
        try {
            new CommandHelper(workDir).runCommand("Changing state for work item $it", command)
        }
        catch (Exception e) {
            println "Error changing state for work item: $it"
            foundErrors = true
        }
    }

    if (workItemIds.split(',').size() == 0) {
        println 'No work items provided!'
    }

    if (foundErrors) System.exit 1
}
catch (Throwable t) {
    t.printStackTrace()
    System.exit 1
}