#!/usr/bin/env groovy

import groovy.xml.StreamingMarkupBuilder
import com.urbancode.anthill3.AHPTool
import com.urbancode.anthill3.CommandHelper

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
try {
    final def workDir = new File('.').canonicalFile

    final def ahpTool = new AHPTool();

    final def props = ahpTool.getStepProperties();
    final def serverUrl = props['repo/serverUrl']
	final def serverUserName = props['repo/userName']
	final def serverPassword = props['repo/password']
	final def tfsVersion = props['repo/serverVersion']
	final def workItemProperty = props['workItemProperty']
	final def workItemRegex = props['workItemRegex']
	final def comment = props['comment']

    def workItemMap = [:] as Map

    // get changeset info
    if (workItemProperty) {
        new XmlSlurper().parseText(ahpTool.getChangeSetsXml())."change-set".each { element ->
            if (element.'properties'.size() > 0) {
                element.'properties'[0].'property'.each {
                    if (workItemProperty.equalsIgnoreCase(it.'name'[0].text())) {
                        it.'value'[0].text().split(',').each {
                            def currentCommentSet = workItemMap[it]?:[] as Set
                            currentCommentSet << element.'comment'[0].text()
                            workItemMap.put(it,currentCommentSet)
                        }
                    }
                }

            }
        }
    }

    if (workItemRegex) {
        ahpTool.getMatchingChangeSets(workItemRegex).each {
            def currentCommentSet = workItemMap[it]?:[] as Set
            currentCommentSet << it.value.'comment'[0].text()
            workItemMap.put(it,currentCommentSet)
        }
    }

    // now prepare tftool command
    if (workItemMap.size() > 0) {
        def hasError = false
        workItemMap.each {
            if (comment) it.value.addAll(comment.split('\n'))
            def command = ['tftool' + tfsVersion + '.exe', 'comment', "/server:$serverUrl"]

            if (serverUserName && serverPassword) {
                command << "/user:$serverUserName"
                command << "/password:$serverPassword"
            }

            command << "/id:${it.key}"
            command << "/comment:${it.value.join('<br>')}"

            try {
                new CommandHelper(workDir).runCommand('Adding Work Item Comment', command)
            }
            catch (Exception e) {
                println e.message
                hasError = true
            }
        }

        if (hasError) {
            println 'Got errors during work item comment updates!'
            System.exit 1
        }
    }
    else {
        println 'Did not detect any work items in changelog!'
    }
}
catch (Throwable t) {
    t.printStackTrace()
    System.exit 1
}