#!/usr/bin/env groovy

import com.urbancode.anthill3.AHPTool
import com.urbancode.anthill3.CommandHelper

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
try {
    final def workDir = new File('.').canonicalFile

    final def ahpTool = new AHPTool();

    final def props = ahpTool.getStepProperties();
    final def serverUrl = props['repo/serverUrl']
	final def serverUserName = props['repo/userName']
	final def serverPassword = props['repo/password']
	final def tfsVersion = props['repo/serverVersion']
	final def project = props['project']
	final def type = props['type']
	final def title = props['title']
	final def description = props['description']
	final def assignee = props['assignee']

    // run tftool command
    def command = ['tftool' + tfsVersion + '.exe', 'create', "/server:$serverUrl"]

    if (serverUserName && serverPassword) {
        command << "/user:$serverUserName"
        command << "/password:$serverPassword"
    }

    command << "/project:$project"
    command << "/type:$type"
    command << "/title:$title"

    if (description) command << "/description:$description"
    if (assignee) command << "/assignTo:$assignee"

    new CommandHelper(workDir).runCommand('Creating work item', command)
}
catch (Throwable t) {
    t.printStackTrace()
    System.exit 1
}
