import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import groovy.xml.StreamingMarkupBuilder
import java.text.SimpleDateFormat

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile

final def dateParser = new DateParser();
final def apTool = new AirPluginTool(args[0], args[1]);

final def props             = apTool.getStepProperties();

final String scmCmd         = props['source/repo/commandPath'] ?: "tf"
final def dirOffset         = props['source/dirOffset']
final def dir               = new File(workDir, dirOffset).canonicalFile // get checkout directory
final def serverUrl         = props['source/repo/serverUrl']
final def serverUserName    = props['source/repo/userName']
final def serverPassword    = props['source/repo/password'] ?: props['source/repo/passScript']
final def tfsVersion        = props['source/repo/serverVersion']
final def sourceLocation    = props['source/sourceLocation']
final def label             = props['source/label']
final def changeset         = props['source/changeset']
final def startDate         = dateParser.parseDate(props['startDate'])
final def endDate           = dateParser.parseDate(props['endDate'])
final def userExcludes      = props['source/userExcludes']
final def fileFilters       = props['source/fileFilters']
final def changesUrl        = props['changesUrl']
final def tfToolPath        = props['tfToolPath']

println "Changes Url: $changesUrl"

//------------------------------------------------------------------------------
// RUN CHANGELOG
//------------------------------------------------------------------------------
dir.mkdirs()

SCMChangelog changelog = new SCMChangelog()
changelog.scmCommand = scmCmd
changelog.workDir = dir
changelog.serverUrl = serverUrl
changelog.serverUserName = serverUserName
changelog.serverPassword = serverPassword
changelog.tfsVersion = tfsVersion
changelog.sourceLocation = sourceLocation

changelog.label = label
changelog.changeset = changeset
changelog.startDate = startDate
changelog.endDate = endDate

changelog.changeSetFilter.setUserExcludes(userExcludes);
changelog.changeSetFilter.setFileFilters(fileFilters);
changelog.changesUrl = changesUrl
changelog.tfToolPath = tfToolPath

changelog.execute()