/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.logging;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@BridgeMethodsAdded
public class LogUtil {
    public static final Level TRACE;

    public static void logDebug(Logger logger, Object message) {
        LogUtil.logDebug(logger, message, null);
    }

    public static void logDebug(Logger logger, Object message, Throwable t) {
        if (logger.isDebugEnabled()) {
            if (t != null) {
                logger.debug(message, t);
            } else {
                logger.debug(message);
            }
        }
    }

    public static boolean isTraceEnabled(Logger logger) {
        return logger.isEnabledFor((Priority)TRACE);
    }

    public static void logTrace(Logger logger, Object message) {
        LogUtil.logTrace(logger, message, null);
    }

    public static void logTrace(Logger logger, Object message, Throwable t) {
        if (logger.isEnabledFor((Priority)TRACE)) {
            if (t != null) {
                logger.log((Priority)TRACE, message, t);
            } else {
                logger.log((Priority)TRACE, message);
            }
        }
    }

    static {
        Level trace;
        try {
            trace = Level.TRACE;
        }
        catch (Throwable t) {
            trace = Level.DEBUG;
        }
        TRACE = trace;
    }
}

