/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*

import java.util.Date;
import java.util.regex.Matcher

public class SCMTag extends SCMStep {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************
    
    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    final def TFS_DATE_FORMAT = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z")
    
    String message
    String changeset
    String label
    Date date
    String newLabel
    
    public void execute() {
        TFS_DATE_FORMAT.timeZone = TimeZone.getTimeZone("UTC")

        createLabel()
    }
    
    public void createLabel() {
        CommandHelper ch = new CommandHelper(workDir)
        
        def labelCommand = [scmCommand, 'label', "/server:$serverUrl", '/recursive', '/child:replace']
        
        if (message) {
            labelCommand << "/comment:$message"
        }
        
        if (changeset) {
            labelCommand << "/version:C$changeset"
        }
        else if (label) {
            labelCommand << "/version:L$label"
        }
        else if (date) {
            labelCommand << ('/version:D' + TFS_DATE_FORMAT.format(date))
        }
        
        labelCommand << newLabel
        labelCommand << sourceLocation
        
        if (serverUserName && serverPassword) {
           labelCommand << "/login:$serverUserName,$serverPassword"
        }
        ch.runCommand('Create Label', labelCommand)
    }
}