/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile

final def apTool = new AirPluginTool(args[0], args[1]);

final def props = apTool.getStepProperties();

final def dirOffset             = props['source/dirOffset'] ?: '.'
final def dir                   = new File(workDir, dirOffset).canonicalFile // get checkout directory
final def scmCmd                = props['source/repo/commandPath'] ?:'tf'
final def serverUrl             = props['source/repo/serverUrl']
final def serverUserName        = props['source/repo/userName']
final def serverUserPassword    = props['source/repo/password'] ?: props['source/repo/passScript']
final def sourceLocation        = props['source/sourceLocation']
final def label                 = props['source/label']
final def changeset             = props['source/changeset']
final def newLabel              = props['label']
final def message               = props['message']
final def date                  = new Date(Long.parseLong(props['date']))

//------------------------------------------------------------------------------
// RUN TAG
//------------------------------------------------------------------------------
dir.mkdirs()

SCMTag tag = new SCMTag()
tag.scmCommand = scmCmd
tag.workDir = dir
tag.serverUrl = serverUrl
tag.serverUserName = serverUserName
tag.serverPassword = serverUserPassword
tag.sourceLocation = sourceLocation

tag.label = label
tag.newLabel = newLabel
tag.changeset = changeset
tag.message = message
tag.date = date

tag.execute()
