/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*
import com.urbancode.air.plugin.scm.changelog.*
import java.util.regex.Matcher

public class SCMQuietPeriod extends SCMChangelog {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    
    CommandHelper ch = new CommandHelper(workDir)
    
    public def execute() {
        TFS_DATE_FORMAT.timeZone = TimeZone.getTimeZone("UTC")
        
        def logOutput = super.runLogCommand()
        
        Date latestDate = parseLogIntoChangesets(logOutput)
        
        println latestDate
        
        return latestDate
    }
    
    public Date parseLogIntoChangesets(String logOutput) {
        def latestChangeDate = new Date(1)
        
        def changeLog = new XmlParser().parseText(logOutput)
        changeLog.'change-sets'[0].'change-set'.each { changeXml ->
            def changeSetDate = TFS_DATE_FORMAT.parse(changeXml.'change-date'[0].text())

            if (changeSetDate.compareTo(endDate) <= 0 && changeSetDate.compareTo(startDate) >= 0 &&
                    latestChangeDate.before(changeSetDate)) {

                ChangeSet changeSet = new ChangeSet()

                changeSet.id = changeXml.'change-id'.text()
                changeSet.date = changeSetDate
                changeSet.user = changeXml.'change-user'.text()
                
                changeXml.'change'.each {change ->
                    ChangeSetFileEntry entry = new ChangeSetFileEntry()
                    entry.path = change.'change-item'[0].text()
                    changeSet.fileSet << entry
                }
                
                boolean hasAllowedAuthor = changeSet.hasAllowedAuthor(changeSetFilter);
                boolean hasAllowedFile = changeSet.hasAllowedPath(changeSetFilter);
                
                if (hasAllowedAuthor && hasAllowedFile && latestChangeDate.before(changeSetDate)) {
                    latestChangeDate = changeSetDate
                }
                else {
                    def message = new StringBuilder("Changeset ${changeSet.id} skipped because ")
                    if (!hasAllowedAuthor) {
                        message << "it has excluded author ${changeSet.user}"
                    }
                    if (!hasAllowedAuthor && !hasAllowedFile) {
                        message << " and "
                    }
                    if (!hasAllowedFile) {
                        message << "it contains only excluded file paths (${changeSet.fileSet.collect{it.path}})"
                    }
                    println message
                }
            }
        }

        return latestChangeDate
    }
}