import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir)
def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def solutionFileName = props['solnFile']
final def cmdPath = props['cmdPath']
final def commandArg = props['commandArg']
final def modeArg = props['modeArg']
final def cmdProps = props['cmdProps']
final def envVars = props['envVars']

def commandLineArgs = []

if (workDir.isFile()) {
    throw new IllegalArgumentException("Working directory ${workDir} is a file!")
}

if (!solutionFileName) {
    throw new IllegalStateException("Solution file is not specified")
}

if (commandArg != null && modeArg == null) {
    throw new IllegalStateException("Cannot specify a commandArg without a modeArg")
}

if (modeArg != null && commandArg == null) {
    throw new IllegalStateException("Cannot specify a modeArg without a commandArg")
}

def solutionFile = new File(workDir, solutionFileName)

if (!cmdPath.endsWith(File.separator)) {
    cmdPath += File.separator
}

def exePath = cmdPath
if (!(cmdPath =~ "devenv([.](exe|bat|com))?\$")) {
    exePath += "devenv"
}

commandLineArgs << exePath << solutionFileName

if (commandArg != null && modeArg != null) {
    commandLineArgs << commandArg << modeArg
}

if (cmdProps) {
    cmdProps.split("\\s").each() { prop ->
        if (prop) {
            commandLineArgs << prop
        }
    }
}

// Set any environment variables on the environment itself
if (envVars) {
    def pb = ch.getProcessBuilder()
    def envProps = pb.environment()
    
    envVars.split('\n').each() { prop ->
        if (prop) {
            def propMap = prop.split("=", 2)
            envProps[propMap[0]] = propMap[1]
        }
    }
}

commandLineArgs << "/Out" << "out.log"

File log = new File("out.log")
if (log.exists()) {
    log.delete()
}
log.createNewFile()

ch.ignoreExitValue(true)
def exitCode = ch.runCommand("Running Visual Studio command", commandLineArgs)

log.eachLine() { line ->
    println line
}
log.delete()

if (exitCode != 0) {
    System.exit(1)
}