/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir)
def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def solutionFileName = props['solnFile']
final def cmdPath = props['cmdPath'] ?: 'devenv'
final def commandArg = props['commandArgument']
final def modeArg = props['modeArgument'] ?: "\"\""
final def cmdProps = props['cmdProps']
final def envVars = props['envVars']

// PLUGINS-2559 use absolute path for log file
final def outFile = new File("out.log").getAbsoluteFile()

def commandLineArgs = []

if (workDir.isFile()) {
    throw new IllegalArgumentException("Working directory ${workDir} is a file!")
}

if (!solutionFileName) {
    throw new IllegalStateException("Solution file is not specified")
}

if (commandArg != null && modeArg == null) {
    throw new IllegalStateException("Cannot specify a commandArg without a modeArg")
}

if (modeArg != null && commandArg == null) {
    throw new IllegalStateException("Cannot specify a modeArg without a commandArg")
}

// Check if the command path from the user ends with a devenv executable. If not, add one
def exePath = cmdPath
if (!(exePath =~ ".*devenv([.](exe|bat|com))?\$")) {
    if (!exePath.endsWith(File.separator)) {
        exePath += File.separator
    }
    exePath += "devenv"
}

def solutionFile = new File(workDir, solutionFileName)
commandLineArgs << exePath << solutionFile

if (commandArg != null && modeArg != null) {
    commandLineArgs << commandArg << modeArg
}

if (cmdProps) {
    cmdProps.split("\\s").each() { prop ->
        if (prop) {
            commandLineArgs << prop
        }
    }
}

// Set any environment variables on the environment itself
if (envVars) {
    def pb = ch.getProcessBuilder()
    def envProps = pb.environment()

    envVars.split('\n').each() { prop ->
        if (prop) {
            def propMap = prop.split("=", 2)
            envProps[propMap[0]] = propMap[1]
        }
    }
}

commandLineArgs << "/Out" << outFile.path

if (outFile.exists()) {
    outFile.delete()
}
outFile.createNewFile()

ch.ignoreExitValue(true)
def exitCode = ch.runCommand("Running Visual Studio command", commandLineArgs)

outFile.eachLine() { line ->
    println line
}
outFile.delete()

if (exitCode != 0) {
    System.exit(1)
}
