import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;

final AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1]);
final File workDir = new File('.').canonicalFile
final CommandHelper cmdHelper = new CommandHelper(workDir);
final Properties stepProps = apTool.getStepProperties()
final File xcodebuildFile = new File(stepProps['xcode_xcodebuild'])
final String workspace = stepProps['xcode_workspace']
final String project = stepProps['xcode_project']
final String target = stepProps['xcode_target']
final String configuration = stepProps['xcode_configuration']
final String scheme = stepProps['xcode_scheme']
final String arch = stepProps['xcode_arch']
final boolean buildActiveArchOnly = Boolean.valueOf(stepProps['xcode_onlyActiveArchs'])
final String sdk = stepProps['xcode_sdk']
final String toolchain = stepProps['xcode_toolchain']
final boolean parallelize = Boolean.valueOf(stepProps['xcode_parallelize'])
final int maxJobs = parallelize && stepProps['xcode_maxJobs'] ? Integer.valueOf(stepProps['xcode_maxJobs']) : -1

final List<Object> commandLine = []
commandLine << xcodebuildFile.absolutePath

if (workspace) {
    commandLine << '-workspace'
    commandLine << workspace
}
else if (project) {
    commandLine << '-project'
    commandLine << project
}

if (scheme) {
    commandLine << '-scheme'
    commandLine << scheme
}
else if (target) {
    commandLine << '-target'
    commandLine << target
}
else {
    commandLine << '-alltargets'
}

if (configuration) {
    commandLine << '-configuration'
    commandLine << configuration
}

if (arch) {
    commandLine << '-arch'
    commandLine << arch
}

if (sdk) {
    commandLine << '-sdk'
    commandLine << sdk
}

if (toolchain) {
    commandLine << '-toolchain'
    commandLine << toolchain
}

if (parallelize) {
    commandLine << '-parallelizeTargets'
    if (maxJobs > 0) {
        commandLine << '-jobs'
        commandLine << maxJobs
    
    }
}

if (!buildActiveArchOnly) {
    commandLine << "ONLY_ACTIVE_ARCHS=NO"
}

cmdHelper.runCommand('Xcode Build', commandLine)
